﻿$(function () {
    $("#myPageAlert").hide();
    PageLoadTrees();//样式操作
    manageObj.getsystemfileurl();//获取文件路径
    $("#txtfriendcount").keyup(function () {
        this.value = this.value.replace(/[^\d]/g, '');
    });
});

//获取文件路径回调
function AsynGetSystemFileUrlResult(jsonResult) {
    $("#filePathIndicator").val(jsonResult.systemsaveurl);
    $("#txtfriendcount").val(jsonResult.talkfriendmaxcount)
    $(".loadingcover").hide();
    $(".loading").hide();
}

//修改文件路径
function UpdateFilePath() {
    manageObj.systemfileurl();
    BtnWaiting("fileBrowsing", 2);
}

//修改文件路径回调
function AsyncSystemFileUrlResult(jsonResult) {
    if (jsonResult.fileurl.length > 0) {
        $("#filePathIndicator").val(jsonResult.fileurl);
    }
    BtnRecovery("fileBrowsing");
}

//提交
function FilePathSubmit() {
    if ($("#txtfriendcount").val().length == 0) {
        ShowError("myPageAlert", "设置好友最大数量不能为空！");
        $("#txtfriendcount").focus()
        return;
    }
    if (parseInt($("#txtfriendcount").val()) < 100 || parseInt($("#txtfriendcount").val()) > 5000) {
        ShowError("myPageAlert", "请设置好友列表数量在 100-5000 范围内！");
        $("#txtfriendcount").focus();
        return;
    }
    $(".loadingcover").show();
    $(".loading").show();
    var strParaJson = $.toJSON({
        systemsaveurl: $("#filePathIndicator").val(),
        talkfriendmaxcount: $("#txtfriendcount").val()
    });
    manageObj.savesystemsaveurl(strParaJson);
}
//提交回调
function AsynSaveSystemSaveUrlResult(jsonResult) {
    if (jsonResult.success) {
        ShowMsg("myPageAlert", "操作成功！");
    } else {
        ShowError("myPageAlert", "提交失败：" + jsonResult.error);
    }
    $(".loadingcover").hide();
    $(".loading").hide();
}

function PageLoadTrees() {
    $(".left-list-l").css({
        height: $(window).height() - 40
    });
    $(".talklist-m").css({
        height: $(window).height() - 130
    });
    $("#right").css({
        height: $(window).height() - 40
    });
    $("#left").css({
        height: $(window).height() - 40
    });

    initTree();
}
$(window).resize(function () {
    PageLoadTrees();
});

